

varying vec4 color;
varying float NdotL;

flat varying vec3 torch;
varying vec2 lmtexcoord;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)







void main()
{

    lmtexcoord.xy = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
    vec3 normal = gl_NormalMatrix * gl_Normal;

    color = gl_Color;

    NdotL = clamp(dot(normal, sunVec), 0, 1);

    vec3 position = mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz;

    torch = ((pow(gl_MultiTexCoord1.x * recip, 4) * 0.5) * vec3(1.0)) * 3;

    gl_Position = taaFunc(toClipSpace4(position));
}
